<?php
/**
 * Restrict Content Integration
 *
 * @package     AutomatorWP\Custom_User_Fields\Restrict_Content_Integration
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

if ( ! class_exists( 'AutomatorWP_Restrict_Content' ) ) {
    return;
}

function automatorwp_custom_user_fields_restrict_content_fields( $fields ) {

    $prefix = '_automatorwp_custom_user_fields_';

    $fields = array_merge( $fields, array(
        $prefix . 'custom_user_fields' => array(
            'name' => __( 'Required Custom User Fields (Optional)', 'automatorwp-pro' ),
            'type' => 'group',
            'options'     => array(
                'add_button'    => __( 'Add Custom User Field', 'automatorwp-pro' ),
                'remove_button' => __( 'Remove Field', 'automatorwp-pro' ),
            ),
            'fields' => array(
                'field' => automatorwp_utilities_ajax_selector_field( array(
                    'name'              => __( 'Field:', 'automatorwp-pro' ),
                    'option_none'       => true,
                    'action_cb'         => 'automatorwp_custom_user_fields_get_fields',
                    'options_cb'        => 'automatorwp_custom_user_fields_options_cb_field',
                    'placeholder'       => __( 'Select a custom user field', 'automatorwp-pro' ),
                    'default'           => ''
                ) ),
                'value' => array(
                    'name' => __( 'Value:', 'automatorwp-pro' ),
                    'type' => 'text',
                    'default' => '',
                ),
            )
        ),
    ));

    return $fields;

}
add_filter( 'automatorwp_restrict_content_post_restrict_fields', 'automatorwp_custom_user_fields_restrict_content_fields' );

function automatorwp_custom_user_fields_restrict_content_is_user_granted_to_post( $granted, $post_id, $user_id ) {

    $prefix = '_automatorwp_custom_user_fields_';

    $custom_user_fields = get_post_meta( $post_id, $prefix . 'custom_user_fields', true );

    if( is_array( $custom_user_fields ) && count( $custom_user_fields ) ) {

        $meet_custom_user_fields = false;
        $any_field_configured = false;

        // Setup table
        $ct_table = ct_setup_table( 'automatorwp_custom_user_fields' );

        foreach( $custom_user_fields as $custom_user_field ) {
            $field_id = absint( $custom_user_field['field'] );
            $value = $custom_user_field['value'];

            if( $field_id !== 0 ) {
                $object = ct_get_object( $field_id );

                if( $object ) {
                    $user_meta_value = get_user_meta( $user_id, $object->meta_key, true );
                    $any_field_configured = true;

                    if( $value === $user_meta_value ) {
                        $meet_custom_user_fields = true;
                    }
                }
            }

        }

        ct_reset_setup_table();

        if( $any_field_configured ) {
            if( ! $meet_custom_user_fields ) {
                return false;
            }
        }
    }

    return $granted;

}
add_filter( 'automatorwp_restrict_content_is_user_granted_to_post', 'automatorwp_custom_user_fields_restrict_content_is_user_granted_to_post', 10, 3 );